import os
from asap.parameters import rcParams
from asap import scantable

def guiflag(sdfile=None,outfile=None,outform='ASAP', overwrite=False):
    """
    GUI flagging method
    Parameters
        sdfile:    input filename
        outfile:   output filename
        outform:   output file format, should be either 'ASAP', 'MS2',
                   'ASCII', or 'STDIFTS'. Default: 'ASAP'
        overwrite: whether or not overwrite output file if exists.
                   Default False
    """
    if not rcParams['plotter.gui']:
        print "ERROR - GUI is not available"
        return
    from asap.flagplotter import flagplotter
    if not (sdfile and outfile):
        print "ERROR - sdfile and outfile is necessary"
        return
    if not os.path.exists(sdfile):
        print "ERROR - invalid input filename '"+sdfile+"'"
        return
    if not overwrite and  os.path.exists(outfile):
        print "ERROR - output file '"+outfile+"' already exists"
        return
    scan = scantable(filename=sdfile,average=False)
    guiflagger = flagplotter(visible=True)
    guiflagger._plotter.legend(loc=0)
    guiflagger.plot(scan)
    finish=raw_input("Press enter to finish interactive flagging:")
    guiflagger._plotter.unmap()
    guiflagger._plotter = None
    del guiflagger
    scan.save(outfile,outform.upper(),overwrite)
    if outform!='ASCII':
        print "Wrote output "+outform+" file "+outfile

