#include "Scantable.h"
#include "STMath.h"
#include "STFillerWrapper.h"
#include <casa/Utilities/CountedPtr.h>
#include <vector>
#include <iostream>

using namespace asap;
using namespace std;

int main() {
  const string fname0 = "/tmp/ASAP_problem/c082812231.rpf";
  ScantableWrapper stw0(0);
  STFillerWrapper stf0(stw0);
  cout << "reading ..." << endl;
  stf0.open(fname0);
  stf0.read();
  stf0.close();

  STMath stm;
  vector<bool> msk;
  vector<casa::CountedPtr<Scantable> > l0;
  l0.push_back(stw0.getCP());
  casa::CountedPtr<Scantable> av0 = stm.average(l0,msk, "NONE", "SCAN");

  const string fname1 = "/tmp/ASAP_problem/c082880100.rpf";
  ScantableWrapper stw1(0);
  STFillerWrapper stf1(stw1);
  cout << "reading ..." << endl;
  stf1.open(fname1);
  stf1.read();
  stf1.close();
  vector<casa::CountedPtr<Scantable> > l1;
  l1.push_back(stw1.getCP());
  casa::CountedPtr<Scantable> av1 = stm.average(l1,msk, "NONE", "SCAN");

  vector<casa::CountedPtr<Scantable> > on;
  on.push_back(av0);
  on.push_back(av1);
 
  casa::CountedPtr<Scantable> avst = stm.merge(on);
  //avst->makePersistent("t.asap");
  return 0;

}
