//#---------------------------------------------------------------------------
//# python_SD.h: python module for single dish package
//#---------------------------------------------------------------------------
//# Copyright (C) 2004
//# ATNF
//#
//# This program is free software; you can redistribute it and/or modify it
//# under the terms of the GNU General Public License as published by the Free
//# Software Foundation; either version 2 of the License, or (at your option)
//# any later version.
//#
//# This program is distributed in the hope that it will be useful, but
//# WITHOUT ANY WARRANTY; without even the implied warranty of
//# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
//# Public License for more details.
//#
//# You should have received a copy of the GNU General Public License along
//# with this program; if not, write to the Free Software Foundation, Inc.,
//# 675 Massachusetts Ave, Cambridge, MA 02139, USA.
//#
//# Correspondence concerning this software should be addressed as follows:
//#        Internet email: Malte.Marquarding@csiro.au
//#        Postal address: Malte Marquarding,
//#                        Australia Telescope National Facility,
//#                        P.O. Box 76,
//#                        Epping, NSW, 2121,
//#                        AUSTRALIA
//#
//# $Id: python_asap.h 873 2006-03-06 00:28:35Z mar637 $
//#---------------------------------------------------------------------------
#ifndef PYTHON_SD_H
#define PYTHON_SD_H

class casa::AipsError;

namespace asap {
  namespace python {
    void translate_ex(const casa::AipsError& e);
    void python_SDMemTable();
    void python_SDReader();
    void python_SDWriter();
    void python_SDMath();
    void python_SDFitter();
    void python_SDFitTable();
    void python_SDLineFinder();
    void python_SDLog();

  } // python
} //asap

#endif
