"""
This is the ATNF Single Dish Analysis package.

"""
import os
import sys

# first import!
from asap.env import *
# second import!
from asap.logging import *
from asap.parameters import *
from asap.utils import *
# explicitly import 'hidden' functions
from asap.utils import _n_bools, _is_sequence_or_number, _to_list


if is_ipython():
    from ipysupport import *

# use rc parameter to enable/disable logging
asaplog.enable(rcParams['verbose'])

setup_env()

# anything which uses matplotlib has to be imported after this!!!
if rcParams['useplotter']:
    try:
        gui = os.environ.has_key('DISPLAY') and rcParams['plotter.gui']
        if gui:
            import matplotlib
            if 'matplotlib.backends' not in matplotlib.sys.modules:
                matplotlib.use("TkAgg")
        from asapplotter import asapplotter
        from matplotlib import pylab
        xyplotter = pylab
        plotter = asapplotter(gui)
    except ImportError:
        asaplog.post( "Matplotlib not installed. No plotting available")
        print_log('WARN')

from asapreader import reader
from selector import selector
from asapmath import *
from scantable import scantable
from linecatalog import linecatalog
from asaplinefind import linefinder
from simplelinefinder import simplelinefinder
from interactivemask import interactivemask
from asapfitter import fitter
from opacity import skydip
from opacity import model as opacity_model

__date__ = '$Date: 2010-08-02 09:40:09 +0000 (Mon, 02 Aug 2010) $'.split()[1]
__version__  = 'trunk'
__revision__ = get_revision()

def welcome():
    return """Welcome to ASAP v%s (%s) - the ATNF Spectral Analysis Package

Please report any bugs via:
http://svn.atnf.csiro.au/trac/asap/simpleticket

[IMPORTANT: ASAP is 0-based]
Type commands() to get a list of all available ASAP commands.""" % (__version__,
                                                                    __date__)
