from os.path import expanduser, expandvars
from asap._asap import Plotter2

class plotter2:
    def __init__(self):
        self._plotter = Plotter2()

    def set_output(self, filename=None, dev=None):
        if filename is None:
            filename = ''
            dev = 'xwindow'
        else:
            filename = filename.strip()
            if filename == '':
                dev = 'xwindow'
            else:
                if (dev is None) or (dev.strip() == ''):
                    fnamelem = filename.lower().split('.')
                    dev = fnamelem[len(fnamelem)-1].strip()
                    if dev == 'ps': dev = 'cps'

        self._plotter.set_filename(expanduser(expandvars(filename)))
        self._plotter.set_device(dev.strip())

    def set_vp(self, xmin, xmax, ymin, ymax, id=None):
        if id is None:
            if self._plotter.get_hasdefaultvp():
                self._plotter.set_viewport(xmin, xmax, ymin, ymax, 0)
            else:
                return self._plotter.add_viewport(xmin, xmax, ymin, ymax)
        else:
            self._plotter.set_viewport(xmin, xmax, ymin, ymax, id)

    def show_vp(self, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.show_viewport(vpid)
    
    def hide_vp(self, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.hide_viewport(vpid)
    
    def set_range(self, xmin, xmax, ymin, ymax, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_range(xmin, xmax, ymin, ymax, vpid)

    def set_xrange(self, xmin, xmax, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_range_x(xmin, xmax, vpid)
    
    def set_yrange(self, ymin, ymax, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_range_y(ymin, ymax, vpid)

    def get_xrange(self, vpid=None):
        if vpid is None: vpid = -1
        return self._plotter.get_range_x(vpid)
    
    def get_yrange(self, vpid=None):
        if vpid is None: vpid = -1
        return self._plotter.get_range_y(vpid)
    
    def set_autorange(self, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_autorange(vpid)

    def set_xautorange(self, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_autorange_x(vpid)
    
    def set_yautorange(self, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_autorange_y(vpid)

    def set_fontsize(self, size, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_fontsize(size, vpid)
    
    def set_xtics(self, interval_major, num_minor=None, vpid=None):
        if vpid is None: vpid = -1 
        if num_minor is None: num_minor = 5
        self._plotter.set_tics_x(interval_major, num_minor, vpid)
    
    def set_ytics(self, interval_major, num_minor=None, vpid=None):
        if vpid is None: vpid = -1
        if num_minor is None: num_minor = 5
        self._plotter.set_tics_y(interval_major, num_minor, vpid)
    
    def set_xautotics(self, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_autotics_x(vpid)
    
    def set_yautotics(self, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_autotics_y(vpid)
    
    def set_xnuminterval(self, interval, vpid=None):
        if vpid is None: vpid = -1 
        self._plotter.set_ninterval_x(interval, vpid)
    
    def set_ynuminterval(self, interval, vpid=None):
        if vpid is None: vpid = -1
        self._plotter.set_ninterval_y(interval, vpid)

    def set_xnumlocation(self, location=None, vpid=None):
        if vpid     is None: vpid     = -1
        if location is None: location = "l"
        self._plotter.set_nlocation_x(location.lower(), vpid)
    
    def set_ynumlocation(self, location=None, vpid=None):
        if vpid     is None: vpid     = -1
        if location is None: location = "b"
        self._plotter.set_nlocation_y(location.lower(), vpid)
    
    def set_data(self, xdata, ydata, vpid=None, dataid=None):
        if dataid is None:
            if vpid is None: vpid = -1
            dataid = -1
        
        self._plotter.set_data(xdata, ydata, vpid, dataid)

    def set_line(self, color, width=None, style=None, vpid=None, dataid=None):
        if width  is None: width  = 1
        if style  is None: style  = "solid"
        if vpid   is None: vpid   = -1
        if dataid is None: dataid = -1
        
        coloridx = self.get_colorindex(color)
        styleidx = self.get_linestyleindex(style)
        self._plotter.set_line(coloridx, width, styleidx, vpid, dataid)

    def show_line(self, vpid=None, dataid=None):
        if dataid is None:
            if vpid is None: vpid = -1
            dataid = -1

        self._plotter.show_line(vpid, dataid)
    
    def hide_line(self, vpid=None, dataid=None):
        if dataid is None:
            if vpid is None: vpid = -1
            dataid = -1

        self._plotter.hide_line(vpid, dataid)
    
    def set_point(self, type, size, color, vpid=None, dataid=None):
        if dataid is None:
            if vpid is None: vpid = -1
            dataid = -1
        coloridx = self.get_colorindex(color)
        self._plotter.set_point(type, size, coloridx, vpid, dataid)

    def show_point(self, vpid=None, dataid=None):
        if dataid is None:
            if vpid is None: vpid = -1
            dataid = -1
        
        self._plotter.show_point(vpid, dataid)

    def hide_point(self, vpid=None, dataid=None):
        if dataid is None:
            if vpid is None: vpid = -1
            dataid = -1
        
        self._plotter.hide_point(vpid, dataid)

    def set_xmask(self, xmin, xmax, color=None, fstyle=None, width=None, hsep=None, vpid=None):
        if color  is None: color  = "lightgray"
        if fstyle is None: fstyle = "solid"
        if width  is None: width  = 1
        if hsep   is None: hsep   = 1.0
        if vpid   is None: vpid   = -1
        coloridx = self.get_colorindex(color)
        fstyleidx = self.get_fillstyleindex(fstyle)
        self._plotter.set_mask_x(xmin, xmax, coloridx, fstyleidx, width, hsep, vpid)

    def set_xlabel(self, label, style=None, size=None, posx=None, posy=None, vpid=None):
        if style is None: style = ""
        if size  is None: size  = 1.1
        if posx  is None: posx  = -1.0
        if posy  is None: posy  = -1.0
        if vpid  is None: vpid  = -1
        
        self._plotter.set_label_x(label, posx, posy, size, style, 1, 0, vpid)
    
    def set_ylabel(self, label, style=None, size=None, posx=None, posy=None, vpid=None):
        if style is None: style = ""
        if size  is None: size  = 1.1
        if posx  is None: posx  = -1.0
        if posy  is None: posy  = -1.0
        if vpid  is None: vpid  = -1
        
        self._plotter.set_label_y(label, posx, posy, size, style, 1, 0, vpid)
    
    def set_title(self, label, style=None, size=None, posx=None, posy=None, vpid=None):
        if style is None: style = ""
        if size  is None: size  = 1.5
        if posx  is None: posx  = -1.0
        if posy  is None: posy  = -1.0
        if vpid  is None: vpid  = -1
        
        self._plotter.set_title(label, posx, posy, size, style, 1, 0, vpid)

    def set_vpbgcolor(self, bgcolor, vpid=None):
        if vpid  is None: vpid  = -1

        if bgcolor.strip() == "":
            coloridx = -1
        else:
            coloridx = self.get_colorindex(bgcolor)
        
        self._plotter.set_vpbgcolor(coloridx, vpid)
    
    def plot(self):  
        self._plotter.plot()

    def save(self, filename):
        self.set_output(filename)
        self.plot()
    
    def get_vinfo(self):
        self._plotter.get_vinfo()

    def get_colorindex(self, colorname):
        name = colorname.strip().lower()

        if name == "white":       idx = 0  # our definition of bgcolor
        if name == "black":       idx = 1  # our definition of fgcolor
        if name == "red":         idx = 2
        if name == "green":       idx = 3
        if name == "blue":        idx = 4
        if name == "cyan":        idx = 5
        if name == "magenta":     idx = 6
        if name == "yellow":      idx = 7
        if name == "orange":      idx = 8
        if name == "yellowgreen": idx = 9
        if name == "emerald":     idx = 10
        if name == "skyblue":     idx = 11
        if name == "purple":      idx = 12
        if name == "pink":        idx = 13
        if name == "gray":        idx = 14
        if name == "lightgray":   idx = 15

        return idx

    def list_colornames(self):
        print "plotter2: default color list ----"
        print "  (0) white (background)"
        print "  (1) black (foreground)"
        print "  (2) red"
        print "  (3) green"
        print "  (4) blue"
        print "  (5) cyan"
        print "  (6) magenta"
        print "  (7) yellow"
        print "  (8) orange"
        print "  (9) yellowgreen"
        print " (10) emerald"
        print " (11) skyblue"
        print " (12) purple"
        print " (13) pink"
        print " (14) gray"
        print " (15) lightgray"
        print "---------------------------------"

    def get_linestyleindex(self, fstyle):
        style = fstyle.strip().lower()
        if style == "solid":        idx = 1
        if style == "outline":      idx = 2
        if style == "hatched":      idx = 3
        if style == "crosshatched": idx = 4
        
        return idx
    
    def list_linestyles(self):
        print "plotter2: fill style list ----"
        print "  (1) solid"
        print "  (2) dashed"
        print "  (3) dash-dotted"
        print "  (4) dotted"
        print "  (5) dash-dot-dot-dotted"
        print "------------------------------"

    def get_fillstyleindex(self, fstyle):
        style = fstyle.strip().lower()
        if style == "solid":        idx = 1
        if style == "outline":      idx = 2
        if style == "hatched":      idx = 3
        if style == "crosshatched": idx = 4
        
        return idx
    
    def list_fillstyles(self):
        print "plotter2: fill style list ----"
        print "  (1) solid"
        print "  (2) outline"
        print "  (3) hatched"
        print "  (4) crosshatched"
        print "------------------------------"

"""
    def set_annotation(self, label, posx=None, posy=None, angle=None, fjust=None, size=None, style=None, color=None, bgcolor=None, vpid=None):
        if posx    is None: posx    = -1.0
        if posy    is None: posy    = -1.0
        if angle   is None: angle   = 0.0
        if fjust   is None: fjust   = 0.5
        if size    is None: size    = 2.0
        if style   is None: style   = ""
        if color   is None: color   = 1 #default foreground colour (b)
        if bgcolor is None: bgcolor = 0 #default backgound colour (w)
        if vpid    is None: vpid    = -1
        
        coloridx = self.get_colorindex(color)
        bgcoloridx = self.get_colorindex(bgcolor)
        self._plotter.set_annotation(label, posx, posy, angle, fjust, size, style, coloridx, bgcoloridx, vpid)
"""
