//
// C++ Interface: FillerBase
//
// Description:
//
// This class is the Base class for all data fillers.
// The derived filler needs to implement
// open()
// close()
// fill()
//
// The fill() method usually iterates over the source data and calls
// the setXYZ() methods for. After all the data for a row has been set via
// these methods, the fill() method needs to call commitRow() to write the
// data to the scantable.
// All arguments which are defaulted in the setXYZ() methods are optional. All
// others should be set explicitly.
//
// Author: Malte Marquarding <asap@atnf.csiro.au>, (C) 2010
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ASAPFILLERBASE_H
#define ASAPFILLERBASE_H

// STL
#include <string>
#include <vector>
// AIPS++
#include <casa/aips.h>

namespace asap
{

class FillerBase
{
  public:
    FillerBase();
    FillerBase(casa::CountedPtr<Scantable> stable);
    virtual ~FillerBase();

    virtual bool open(const std::string& filename)=0;
    virtual void fill() = 0;
    virtual void close() = 0;

  protected:

    casa::CountedPtr<Scantable> getTable();
    void commitRow();
    virtual void setHeader(const STHeader& header);
    virtual void setSpectrum(const casa::Vector<Float>& spectrum,
                             const casa::Vector<uChar>& flags) ;
    virtual void setIndex(uInt scanno, uInt cycleno, uInt ifno, uInt polno,
                          uInt beamno=0);
    virtual void setFrequency(casa::Double refpix, casa::Double refval,
                              casa::Double incr);
    virtual void setMolecule(casa::Double restfreq);
    virtual void setDirection(const casa::Vector<Double>& dir,
                              casa::Float az=0.0f, casa::Float el=0.0f);

    virtual void setFocus(casa::Float pa=0.0f, casa::Float faxis=0.0f,
                          casa::Float ftan=0.0f, casa::Float frot=0.0f)
    virtual void setTime(casa::Double mjd, casa::Double integration);
    virtual void setWeather(casa::Float temperature=0.0f,
                            casa::Float pressure=0.0f,
                            casa::Float humidity=0.0f,
                            casa::Float windspeed=0.0f,
                            casa::Float windaz=0.0f);
    virtual void setTcal(const casa::String& caltime="",
                         const casa::Vector<Float>& tcal=casa::Vector<Float>())
    virtual void setScanRate(const casa::Vector<Double>& srate=casa::Vector<Double>());
    virtual void setReferenceBeam(Int beamno=-1);
    virtual void setSource(const std::string& name, Int type,
                           const std::string& fieldname="",
                           const casa::Vector<Double>& dircasa::Vector<Double>(),
                           const casa::Vector<Double>& propermot=casa::Vector<Double>(),
                           Double velocity=0.0);

  private:

    casa::CountedPtr< Scantable > table_;
    casa::String referenceRx_;

    casa::TableRow row_;
}


};
