//
// C++ Interface: Filler
//
// Description:
//
//
// Author: Malte Marquarding <asap@atnf.csiro.au>, (C) 2010
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ASAPFILLER_H
#define ASAPFILLER_H

#include <casa/aips.h>
#include <casa/Exceptions.h>
#include <casa/Utilities/CountedPtr.h>
#include <string>

#include "ScantableWrapper.h"
#include "FillerBase.h"
/*
#include "PKSFiller.h"
#include "NROFiller.h"
*/

namespace asap
{
class FillerWrapper
{
public:

  FillerWrapper() : filler_(0), attached_(false), stable_(0) {;}

  FillerWrapper(ScantableWrapper tbl) : filler_(0), attached_(false)
  { stable_ = tbl.getCP(); }

  virtual ~FillerWrapper() { close(); }


//  void open(const std::string& filename, casa::Record rec) {
  void open(const std::string& filename) {
//    filler_ = new ATFiller(stable_);
//    if (filler_->open(filename, rec)) {
    if (filler_->open(filename)) {
      attached_ = true;
      return;
    }
//    filler_ = new NROFiller(stable_);
//    if (filler_->open(filename, rec)) {
    if (filler_->open(filename)) {
      attached_ = true;
      return;
    }
    filler_ = 0;
    attached_ = false;
    throw casa::AipsError("Unknown Data Format");
  }
  void close() {
    if (attached_) {
      filler_->close();
    }
  }

  void fill() {
    if (attached_) {
      filler_->fill();
    }
  }

  void setReferenceRegex(const std::string& rx) {
    if (attached_) {
      filler_->setReferenceRegex(rx);
    }
  }

private:

  casa::CountedPtr<FillerBase> filler_;
  bool attached_;
  casa::CountedPtr<Scantable> stable_;
};

};
#endif
