//
// C++ Interface: Filler
//
// Description:
//
//
// Author: Malte Marquarding <asap@atnf.csiro.au>, (C) 2010
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ASAPFILLER_H
#define ASAPFILLER_H

#include <casa/aips.h>
#include <casa/Utilities/CountedPtr.h>
#include <string>

namespace asap
{
class Filler
{
public:
  Filler() : filler_p(0) {;};

  ~Filler() { close(); };

  void open(const std::string& filename) {
    filler_p = new ATFiller();
    if (filler_p->open(filename)) {
      return;
    }
    filler_p = new NROFiller();
    if (filler_p->open(filename)) {
      return;
    }
    throw AipsError("Unknown Data Format");
  }
  void close() {
    if (filler_p) {
      filler_p->close();
    }
  }

  void fill() {
    if (filler_p) {
      filler_p->fill();
    }
  }
  void setReferenceRx(const std::string& rx) {
    if (filler_p) {
      filler_p->setReferenceRx(rx);
    }
  }

private:
  casa::CountedPtr<FillerBase> filler_p;
};


};
