#ifndef ASAPACCELERATOR_H
#define ASAPACCELERATOR_H
//
// C++ Interface: CustomTableExprNode
//
// Description:
//	Various utilities for speed.
//
// Author: Kohji Nakamura <k.nakamura@nao.ac.jp>, (C) 2012
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <tables/Tables/ExprNode.h>
#include <tables/Tables/ScalarColumn.h>

namespace asap {

using namespace casa;

class CustomTableExprNodeRep :public TableExprNodeRep {
public:
	CustomTableExprNodeRep(const Table &table)
	:TableExprNodeRep(TableExprNodeRep::NTBool,
		TableExprNodeRep::VTScalar,
		TableExprNodeRep::OtUndef,
		table) {}
};

class TableExprPredicate {
public:
	virtual ~TableExprPredicate() {}
	virtual Bool match(Table const& table, const TableExprId& id) const = 0;
};

class CustomTableExprNode: public TableExprNode {
	CustomTableExprNodeRep const nodeRep;
	TableExprPredicate const & pred_;
public:
	CustomTableExprNode(Table const &table, TableExprPredicate const &pred)
	: TableExprNode(), nodeRep(table), pred_(pred) {
	}
	virtual ~CustomTableExprNode() {
	}
	const TableExprNodeRep* getNodeRep() const {
		return &nodeRep;
	}
	void get(const TableExprId& id, Bool& value) const {
		value = pred_.match(nodeRep.table(), id);
	}
};

template<typename T, size_t N>
class SingleTypeEqPredicate: public TableExprPredicate {
	Table const & table;
	ROScalarColumn<T> *cols[N];
	T const *values;
public:
	SingleTypeEqPredicate(Table const &table_, 
		char const*const colNames[],
		T const values_[]):
			table(table_), values(values_) {
		for (size_t i = 0; i < N; i++) {
			cols[i] = new ROScalarColumn<T>(table, colNames[i]);
		}
	}
	virtual ~SingleTypeEqPredicate() {
		for (size_t i = 0; i < N; i++) {
			delete cols[i];
		}
	}
	virtual Bool match(Table const& table, const TableExprId& id) const {
		for (size_t i = 0; i < N; i++) {
			T v;
			cols[i]->get(id.rownr(), v);
			if (v != values[i]) {
				return false;
			}
		}
		return true;
	}
};

} // asap

#endif // ASAPACCELERATOR_H
